package com.bycom.versapro.Utils;

import static com.bycom.versapro.Serializables.Constant.statusBarHeight;
import static com.bycom.versapro.Utils.PrefUtil.isNight;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Color;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.transition.ChangeBounds;
import android.transition.ChangeImageTransform;
import android.transition.ChangeTransform;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.view.View;
import androidx.activity.ComponentActivity;
import androidx.activity.EdgeToEdge;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.bycom.versapro.R;

public class AppUtil {

    public static void launchChromeCustomTab(Activity activity, Uri url){
        CustomTabColorSchemeParams colorSchemeParams = new CustomTabColorSchemeParams.Builder()
                .setToolbarColor(ContextCompat.getColor(activity,R.color.background_color))
                .setNavigationBarColor(ContextCompat.getColor(activity,R.color.background_color))
                .build();

        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
        builder.setDefaultColorSchemeParams(colorSchemeParams);
        CustomTabsIntent customTabsIntent = builder.build();
        customTabsIntent.launchUrl(activity, url);
    }


    public static void EdgeToEdgeEnable(ComponentActivity activity, View view){
        EdgeToEdge.enable(activity);
        ViewCompat.setOnApplyWindowInsetsListener(view, (v, windowInsets) -> {
            Insets insetsSystemBar = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars());
            Insets insetsIME = windowInsets.getInsets(WindowInsetsCompat.Type.ime());


            if(statusBarHeight==0) statusBarHeight = insetsSystemBar.top;

            v.setPadding(
                    0,
                    statusBarHeight,
                    0,
                    Math.max(insetsSystemBar.bottom, insetsIME.bottom)
            );

            return WindowInsetsCompat.CONSUMED;
        });
    }

    public static boolean isDebugBuild(Context context) {
        return (context.getApplicationInfo().flags & ApplicationInfo.FLAG_DEBUGGABLE) != 0;
    }


    public static Transition getImageTransition() {
        TransitionSet set = new TransitionSet();
        set.setDuration(300);
        set.setOrdering(TransitionSet.ORDERING_TOGETHER);
        set.addTransition(new ChangeBounds());
        set.addTransition(new ChangeImageTransform());
        set.addTransition(new ChangeTransform());
        return set;
    }


    public static String getWebViewStyle(Activity activity){

        int textColor = ContextCompat.getColor(activity, R.color.text_color);
        int linkColor = ContextCompat.getColor(activity, R.color.link_color);

        String textColorHex = String.format("#%06X", (0xFFFFFF & textColor));
        String linkColorHex = String.format("#%06X", (0xFFFFFF & linkColor));

        return "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no\">" +
                "<style>" +
                "@font-face {" +
                "    font-family: CustomFont;" +
                "    src: url(\"fonts/poppins.ttf\");" +
                "}" +
                "pre {" +
                "    white-space: pre-wrap;" +
                "    word-wrap: break-word;" +
                "    overflow-wrap: break-word;" +
                "    line-height: 1.7;" +
                "}" +
                "iframe {" +
                "    width: 100%;" +
                "    height: auto;" +
                "    max-width: 100%;" +
                "    aspect-ratio: 16 / 9;" +
                "    display: block;" +
                "    margin: 0 auto;" +
                "}" +
                "blockquote {" +
                "    margin-left: 0;" +
                "    margin-right: 0;" +
                "}" +
                "table {" +
                "    table-layout: fixed;" +
                "    width: 100%;" +
                "    border-collapse: collapse;" +
                "}" +
                "figure {" +
                "    margin: 0;" +
                "    padding: 0;" +
                "    max-width: 100%;" +
                "    overflow: hidden;" +
                "}" +
                "table, th, td {" +
                "    border: 1px solid " + textColorHex + ";" +
                "    word-break: break-word;" +
                "}" +
                "th, td {" +
                "    padding: 10px;" +
                "    text-align: center;" +
                "}" +
                "body {" +
                "    color: " + textColorHex + ";" +
                "    font-family: 'CustomFont';" +
                "    font-size: 15px;" +
                "    margin: 0 15px;" +
                "}" +
                "ul, ol {" +
                "    padding-left: 25px;" +
                "    padding-right: 25px;" +
                "}" +
                "a {" +
                "    color: " + linkColorHex + ";" +
                "    text-decoration: none;" +
                "}" +
                "a:hover {" +
                "    text-decoration: underline;" +
                "}" +
                "img, video {" +
                "    display: block;" +
                "    margin: 5px 0;" +
                "    width: 100% !important;" +
                "    height: auto !important;" +
                "}" +
                "</style>" +
                "<script>" +
                "    document.addEventListener(\"DOMContentLoaded\", function() {" +
                "        var videos = document.querySelectorAll('video[data-src]');" +
                "        videos.forEach(function(video) {" +
                "            var dataSrc = video.getAttribute('data-src');" +
                "            if (dataSrc) {" +
                "                video.setAttribute('src', dataSrc);" +
                "                video.removeAttribute('data-src');" +
                "            }" +
                "        });" +
                "    });" +
                "</script>" +
                "<script>" +
                "    document.addEventListener(\"DOMContentLoaded\", function() {" +
                "        var youtubeVideos = document.querySelectorAll('.shortcode--youtube');" +
                "        youtubeVideos.forEach(function(youtubeVideo) {" +
                "            var youtubeId = youtubeVideo.querySelector('.youtube-video').getAttribute('data-youtube-id');" +
                "            youtubeVideo.innerHTML = '';" +
                "            var iframe = document.createElement('iframe');" +
                "            iframe.setAttribute('src', 'https://www.youtube.com/embed/' + youtubeId + '?autoplay=1');" +
                "            iframe.setAttribute('frameborder', '0');" +
                "            iframe.setAttribute('allow', 'accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture');" +
                "            iframe.setAttribute('allowfullscreen', '');" +
                "            youtubeVideo.appendChild(iframe);" +
                "        });" +
                "    });" +
                "</script>";

    }


    public static boolean isColorDark(int color) {
        double r = Color.red(color) / 255.0;
        double g = Color.green(color) / 255.0;
        double b = Color.blue(color) / 255.0;
        double max = Math.max(r, Math.max(g, b));
        double min = Math.min(r, Math.min(g, b));
        double luminance = (max + min) / 2.0;
        return luminance < 0.7;
    }


    public static int adjustColorBrightness(String color, int level){
        float[] hsl = new float[3];
        ColorUtils.colorToHSL(Color.parseColor(color), hsl);

        if(isNight()){
            hsl[2] = level/100f;
        }else {
            hsl[2] = (100 - level)/100f;
        }

        return ColorUtils.HSLToColor(hsl);
    }

    public static boolean isNoInternet(Context context) {
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        return cm == null || cm.getNetworkCapabilities(cm.getActiveNetwork()) == null;
    }
}
